/******************************************************************************/
class VarParticles : VarBase
{
public:
            VarParticles();
   virtual ~VarParticles();
   
   virtual void create(Object &obj); 
   
   // Setters
   void SetFileUID (UID fileUID) { m_FileUID = fileUID; }
   void SetScale   (flt scale  ) { m_Scale   = scale;   }
   void SetPosition(Vec pos    ) { m_Pos     = pos;     }
   void SetDraw    (bool draw  )
   {
      m_Draw = draw;
      
      if(draw)
      { 
         CreateParticles();
      }
      else
      {
         RemoveParticles();
      }
   }
   
   // Getters
   UID  GetFileUID () { return m_FileUID; }
   flt  GetScale   () { return m_Scale;   }
   Vec  GetPosition() { return m_Pos;     }
   bool GetDraw    () { return m_Draw;    }
   
private:

   UID m_FileUID;
   flt m_Scale;
   Vec m_Pos;
   bool m_Draw;
   
   ObjTempParticles* m_Particles;
   
   void CreateParticles();
   void RemoveParticles();

}
/******************************************************************************/
VarParticles::VarParticles() : m_Draw(false), m_Particles(null), m_Pos(0), m_Scale(1)                        
{
   
}
VarParticles::~VarParticles()
{
   
}
/******************************************************************************/
void VarParticles::create(Object &obj)
{
   // Getting the parameters from the object in the world
   if(Param *p = obj.findParam("FileUID"))  m_FileUID = p.asID();
   if(Param *p = obj.findParam("Position")) m_Pos     = p.asVec();
   if(Param *p = obj.findParam("Scale"))    m_Scale   = p.asFlt();
   
   super.create(obj);
}
/******************************************************************************/
void VarParticles::CreateParticles()
{
   // Particles aren't yet created
   if(!m_Particles)
   {
      // Spawn the particles by adding to the world manager
      ObjectPtr params = m_FileUID;
      Game.Obj* obj = Game.World.objCreateNear(*params, Matrix(params->scale3()*m_Scale, m_Pos));
      m_Particles = CAST(ObjTempParticles, obj);
   }
}
/******************************************************************************/
void VarParticles::RemoveParticles()
{
   m_Particles.RemoveWithFading();
}

